// Version/Precision tags are added programmatically on shader load

#define MAX_BONES %

attribute vec3 vPosition;
attribute vec3 vaNormal;
attribute vec3 vaColor;
attribute vec2 vaUV;
attribute float vaWeight1;
attribute float vaWeight2;

uniform mat4 mProj;
uniform mat4 mView;
uniform mat4 mModel;
uniform mat4 mBones[MAX_BONES];
uniform vec3 uLightPos;
uniform mat4 mDepthBiasMVP;

varying vec3 C; // Color
varying vec3 L; // Light
varying vec3 N; // Normal
varying vec2 UV; // UV

varying vec3 ShadowCoord;

void main()
{
  C = vaColor;
  L = normalize(vec3(mView * vec4(uLightPos, 0.0)));
  UV = vaUV;
  
  int bone1 = int(vaWeight1);
  int bone2 = int(vaWeight2);

  // Multiplied with 0.9 in code to avoid rounding Id up to next bone
  float bone1w = fract(vaWeight1) / 0.9;
  float bone2w = fract(vaWeight2) / 0.9;

  N = vaNormal * mat3(mBones[bone1]) * bone1w + 
      vaNormal * mat3(mBones[bone2]) * bone2w;
  N = normalize(mat3(mView) * mat3(mModel) * N);
  
  vec4 vert = vec4(vPosition, 1.0) * mBones[bone1] * bone1w +
              vec4(vPosition, 1.0) * mBones[bone2] * bone2w;
  vert.w = 1.0;

  // SHADOWS
  ShadowCoord = vec3(mDepthBiasMVP * mModel * vert);

  gl_Position = mProj * mView * mModel * vert;
}